<?php
$contentPath = __DIR__ . '/data/content.json';
if (!is_file($contentPath)) {
  http_response_code(500);
  exit('Content file missing.');
}

$contentJson = file_get_contents($contentPath);
$content = json_decode($contentJson, true);
if (!is_array($content)) {
  http_response_code(500);
  exit('Invalid content configuration.');
}

function esc($value): string {
  return htmlspecialchars((string)($value ?? ''), ENT_QUOTES, 'UTF-8');
}

function raw_text($value): string {
  return (string)($value ?? '');
}

function build_attributes(?array $attributes): string {
  if (empty($attributes)) {
    return '';
  }
  $out = '';
  foreach ($attributes as $key => $val) {
    $out .= ' ' . $key . '="' . esc($val) . '"';
  }
  return $out;
}
?>
<!doctype html>
<html lang="fr">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= esc($content['site']['title'] ?? '') ?></title>
  <meta name="description" content="<?= esc($content['site']['meta_description'] ?? '') ?>" />
  <meta name="theme-color" content="<?= esc($content['site']['theme_color'] ?? '') ?>" />

  <!-- Open Graph / SEO -->
  <meta property="og:type" content="<?= esc($content['site']['og']['type'] ?? '') ?>" />
  <meta property="og:title" content="<?= esc($content['site']['og']['title'] ?? '') ?>" />
  <meta property="og:description" content="<?= esc($content['site']['og']['description'] ?? '') ?>" />
  <meta property="og:image" content="<?= esc($content['site']['og']['image'] ?? '') ?>" />
  <meta property="og:url" content="<?= esc($content['site']['og']['url'] ?? '') ?>" />
  <meta name="twitter:card" content="summary_large_image" />

  <!-- Favicons (à remplacer) -->
  <link rel="icon" href="/assets/favicon.ico" />

  <!-- Bootstrap 5 & Icons (CDN) -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet" />

  <!-- Font - Senatory style -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Barlow:wght@400;500;600;700;800;900&family=Roboto:wght@300;400;500;700&display=swap" rel="stylesheet" />

  <!-- AOS - Animate On Scroll -->
  <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet" />

  <!-- Style de marque modernisé -->
  <link rel="stylesheet" href="/assets/styles.css" />
</head>
<body>
  <?php 
  // Inclure le menu principal
  $currentPage = 'index.php';
  include __DIR__ . '/menu.php';
  ?>

  <!-- Hero - Senatory style -->
  <header id="hero" class="hero">
    <!-- Scout branding motifs -->
    <div class="scout-fleur-de-lys top-left">⚜</div>
    <div class="scout-fleur-de-lys top-right">⚜</div>
    <div class="scout-fleur-de-lys bottom-left">⚜</div>
    <div class="scout-fleur-de-lys bottom-right">⚜</div>
    <div class="hero-overlay"></div>
    <div class="hero-poster">
      <img src="/assets/poster.png" alt="Affiche de campagne - <?= esc($content['hero']['about']['title'] ?? '') ?>" class="img-fluid" loading="lazy" />
              </div>
    <div class="container hero-content">
      <div class="row justify-content-center">
        <div class="col-lg-8 text-center">
          <span class="hero-eyebrow"><?= esc($content['hero']['chip'] ?? 'Campagne Commissaire Général ASB') ?></span>
          <h1 class="display-5 mb-3"><?= raw_text($content['hero']['title'] ?? '') ?></h1>
          <p class="lead slogan"><?= raw_text($content['hero']['subtitle'] ?? '') ?></p>
          <div class="hero-ctas">
            <?php if (!empty($content['hero']['ctas'][0])): ?>
              <a href="<?= esc($content['hero']['ctas'][0]['href'] ?? '#') ?>" class="hero-cta-primary">
                <?= esc($content['hero']['ctas'][0]['label'] ?? 'Rejoignez-nous') ?>
                <i class="bi bi-arrow-right"></i>
              </a>
            <?php endif; ?>
            <a href="#portrait" class="hero-cta-secondary">
              <div class="hero-play-btn">
                <i class="bi bi-play-fill"></i>
          </div>
              <span>Découvrir le candidat</span>
            </a>
          </div>
        </div>
              </div>
            </div>
    <a href="#contact" class="hero-vertical-cta">
      <i class="bi bi-check-square"></i>
      <span>Soutenir</span>
    </a>
  </header>

  <!-- Feature Cards - Valeurs clés de l'engagement -->
  <section class="senatory-feature-cards" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <div class="row g-4">
        <?php 
        $keyPillars = array_slice($content['pillars']['items'] ?? [], 0, 4);
        foreach ($keyPillars as $index => $pillar): 
        ?>
        <div class="col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="<?= $index * 100 ?>">
          <div class="senatory-card">
            <div class="senatory-card-icon">
              <?php 
              $iconImage = $pillar['icon_image'] ?? '';
              if (!empty($iconImage)): 
              ?>
                <img src="/assets/<?= esc($iconImage) ?>" alt="<?= esc($pillar['title'] ?? '') ?>" class="senatory-icon-image" />
              <?php else: ?>
                <i class="<?= esc($pillar['icon'] ?? 'bi bi-check-circle') ?>"></i>
            <?php endif; ?>
          </div>
            <h3><?= esc($pillar['title'] ?? '') ?></h3>
        </div>
      </div>
        <?php endforeach; ?>
    </div>
    </div>
  </section>

  <!-- Portrait du candidat - Senatory style -->
  <section id="portrait" class="py-5" style="background: #fff;" data-aos="fade-up" data-aos-delay="200">
    <div class="container-fluid px-0">
      <div class="portrait-wrapper">
        <div class="portrait-photo-section">
          <img src="/assets/portrait.png " alt="<?= esc($content['portrait']['image_alt'] ?? '') ?>" loading="lazy" />
          <div class="portrait-vertical-bar">
            <i class="bi bi-quote portrait-vertical-icon"></i>
            <div class="portrait-vertical-text">
              Servir avec cœur<br />
              et détermination<br />
              Depuis <?php 
                $firstStat = $content['portrait']['stats'][0]['value'] ?? '1991';
                $currentYear = date('Y');
                $years = $currentYear - intval($firstStat);
                echo $years . '+ années';
              ?>
            </div>
            <div class="portrait-vertical-line"></div>
            </div>
          </div>
        <div class="portrait-content-section">
          <p class="portrait-eyebrow">
            En savoir plus sur
            <i class="bi bi-star-fill"></i>
            <i class="bi bi-star-fill"></i>
            <i class="bi bi-star-fill"></i>
          </p>
          <h2 class="portrait-main-title"><?= esc($content['portrait']['title'] ?? 'Qui je suis') ?><br /><?= esc($content['portrait']['subtitle'] ?? '') ?></h2>
          <p class="portrait-description"><?= esc($content['portrait']['description'] ?? '') ?></p>
          <?php if (!empty($content['portrait']['convictions']['items'])): ?>
            <div class="portrait-features">
              <?php 
              $convictions = array_slice($content['portrait']['convictions']['items'] ?? [], 0, 3);
              $icons = ['bi bi-arrow-right-square', 'bi bi-arrow-right-square', 'bi bi-arrow-right-square'];
              foreach ($convictions as $index => $conviction): 
              ?>
                <div class="portrait-feature-item">
                  <div class="portrait-feature-icon">
                    <?php 
                    $iconImage = $conviction['icon_image'] ?? '';
                    if (!empty($iconImage)): 
                    ?>
                      <img src="/assets/<?= esc($iconImage) ?>" alt="<?= esc($conviction['title'] ?? '') ?>" class="portrait-feature-icon-image" />
                    <?php else: ?>
                      <i class="<?= esc($icons[$index] ?? 'bi bi-check-circle') ?>"></i>
                    <?php endif; ?>
        </div>
                  <div class="portrait-feature-content">
                    <h4><?= esc($conviction['title'] ?? '') ?></h4>
                    <p><?= esc($conviction['text'] ?? '') ?></p>
                </div>
              </div>
            <?php endforeach; ?>
            </div>
          <?php endif; ?>
          
          <!-- Statistics blocks - All stats -->
          <?php if (!empty($content['portrait']['stats'])): ?>
            <div class="portrait-stats-container" data-aos="fade-up" data-aos-delay="300">
              <?php 
              $allStats = $content['portrait']['stats'];
              // Afficher toutes les stats disponibles (au moins 2, max 4 pour le design)
              $statsToShow = array_slice($allStats, 0, min(count($allStats), 4));
              foreach ($statsToShow as $stat): 
              ?>
                <div class="portrait-stat-block">
                  <div class="portrait-stat-number"><?= esc($stat['value'] ?? '') ?></div>
                  <div class="portrait-stat-label"><?= esc($stat['label'] ?? '') ?></div>
                </div>
                  <?php endforeach; ?>
              </div>
          <?php endif; ?>
          
          <!-- Career timeline integrated -->
          <div class="portrait-career-timeline" data-aos="fade-up" data-aos-delay="400">
            <div class="portrait-career-header-inline">
              <div class="portrait-career-eyebrow">Parcours Scout</div>
              <h3 class="portrait-career-title-inline">Mon Parcours dans le Mouvement Scout</h3>
            </div>
            <div class="portrait-career-items">
              <?php 
              $careerStages = [
                ['icon' => 'bi bi-compass', 'icon_image' => '', 'title' => 'Éclaireur & Routier', 'date' => '1995 - 2000'],
                ['icon' => 'bi bi-people', 'icon_image' => '', 'title' => 'Chef de Troupe & Grappe', 'date' => '2000 - 2010'],
                ['icon' => 'bi bi-mortarboard', 'icon_image' => '', 'title' => 'Formateur des Formateurs', 'date' => '2010 - Présent'],
                ['icon' => 'bi bi-shield-check', 'icon_image' => '', 'title' => 'Vice-Président Fondation', 'date' => '2015 - Présent']
              ];
              $delays = [450, 500, 550, 600, 650];
              foreach ($careerStages as $idx => $stage): 
              ?>
                <div class="portrait-career-item" data-aos="fade-up" data-aos-delay="<?= $delays[$idx] ?>">
                  <div class="portrait-career-icon-wrapper">
                    <?php if (!empty($stage['icon_image'])): ?>
                      <img src="/assets/<?= esc($stage['icon_image']) ?>" alt="<?= esc($stage['title']) ?>" class="portrait-career-icon-image" />
                    <?php else: ?>
                      <i class="bi <?= esc($stage['icon']) ?> portrait-career-icon"></i>
                    <?php endif; ?>
          </div>
                  <div class="portrait-career-item-title"><?= esc($stage['title']) ?></div>
                  <div class="portrait-career-item-date"><?= esc($stage['date']) ?></div>
        </div>
              <?php endforeach; ?>
      </div>
    </div>
          
          <a href="#piliers" class="portrait-cta">
            Lire la suite
            <i class="bi bi-arrow-right"></i>
          </a>
          </div>
          </div>
          </div>
  </section>

  <!-- Pourquoi je m'engage - Two column model -->
        </div>
          </div>
        </div>
  </section>

  <!-- Pourquoi je m'engage - Two column model -->
  <section id="engagement-preview" data-aos="fade-up" data-aos-delay="100">
    <div class="engagement-wrapper">
      <!-- Left column: Photo -->
      <div class="engagement-image-col" data-aos="fade-right" data-aos-delay="150">
        <img src="/assets/portrait.png" alt="<?= esc($content['portrait']['image_alt'] ?? 'Portrait du candidat') ?>" loading="lazy" />
          </div>
      <!-- Right column: Content on dark blue background -->
      <div class="engagement-content-col" data-aos="fade-left" data-aos-delay="200">
        <span class="engagement-eyebrow"><?= esc($content['engagement']['excerpt']['eyebrow'] ?? 'Mon engagement') ?></span>
        <h2 class="engagement-title">
          <?php 
          $title = $content['engagement']['excerpt']['title'] ?? 'Pourquoi je m\'engage ?';
          $titleParts = explode(' ', $title);
          $lastWord = array_pop($titleParts);
          $restTitle = implode(' ', $titleParts);
          ?>
          <?= esc($restTitle) ?><br />
          <span class="highlight"><?= esc($lastWord) ?></span>
        </h2>
        <p class="engagement-text"><?= raw_text($content['engagement']['excerpt']['intro'] ?? '') ?></p>
        <p class="engagement-text"><?= raw_text($content['engagement']['excerpt']['excerpt'] ?? '') ?></p>
        <div class="engagement-quote-block">
          <div class="engagement-quote-text">
            Servir avec cœur et détermination<br />
            Depuis <?= esc($content['portrait']['stats'][1]['value'] ?? '33+') ?> années
        </div>
        </div>
        <a href="<?= esc($content['engagement']['excerpt']['cta_href'] ?? 'pourquoi.php') ?>" class="engagement-cta">
          <?= esc($content['engagement']['excerpt']['cta_label'] ?? 'Lire la suite') ?>
          <i class="<?= esc($content['engagement']['excerpt']['cta_icon'] ?? 'bi bi-arrow-right') ?>"></i>
        </a>
      </div>
    </div>
  </section>

  <!-- Vision & Mission - New format with red card left and white cards right -->
  <section id="vision" class="py-5 bg-cream" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <div class="vision-mission-grid">
        <!-- Left: Large red card with vision/mission -->
        <div class="vision-red-card" data-aos="fade-right" data-aos-delay="150" data-aos-duration="800" data-aos-easing="ease-out-cubic">
          <div class="vision-red-card-overlay"></div>
          <div class="vision-red-card-content">
            <div>
              <div class="vision-red-card-eyebrow">
                <?= esc($content['vision']['eyebrow'] ?? 'Feuille de route') ?> ★★★
          </div>
              <h2 class="vision-red-card-title"><?= esc($content['vision']['title'] ?? 'Vision & Mission') ?></h2>
              <p class="vision-red-card-subtitle"><?= esc($content['vision']['subtitle'] ?? '') ?></p>
              <div class="vision-red-card-text">
                <h3 class="h5 mb-3"><?= esc($content['vision']['objective']['title'] ?? '') ?></h3>
                <p><?= esc($content['vision']['objective']['text'] ?? '') ?></p>
          </div>
              <?php if (!empty($content['vision']['cards'])): ?>
                <?php foreach (array_slice($content['vision']['cards'], 0, 1) as $card): ?>
                  <div class="vision-red-card-highlight">
                    <strong><?= esc($card['title'] ?? '') ?></strong><br />
                    <?= esc($card['text'] ?? '') ?>
        </div>
            <?php endforeach; ?>
              <?php endif; ?>
          </div>
            <a href="#piliers" class="vision-red-card-cta">
              En savoir plus <i class="bi bi-arrow-right"></i>
            </a>
        </div>
          </div>
        
        <!-- Right: Grid of 4 white cards with specific objectives -->
        <div class="vision-white-cards-grid">
          <?php 
          $specificItems = $content['vision']['specific_items'] ?? [];
          $cardsToShow = array_slice($specificItems, 0, 4);
          $icons = ['bi bi-shield-check', 'bi bi-graph-up-arrow', 'bi bi-people-fill', 'bi bi-heart'];
          
          foreach ($cardsToShow as $index => $item): 
          ?>
            <div class="vision-white-card" data-aos="fade-left" data-aos-delay="<?= 200 + ($index * 100) ?>" data-aos-duration="800" data-aos-easing="ease-out-cubic">
              <div class="vision-white-card-icon">
                <?php 
                $iconImage = $item['icon_image'] ?? '';
                if (!empty($iconImage)): 
                ?>
                  <img src="/assets/<?= esc($iconImage) ?>" alt="<?= esc($item['title'] ?? '') ?>" class="vision-icon-image" />
                <?php else: ?>
                  <i class="<?= esc($icons[$index] ?? 'bi bi-check-circle') ?>"></i>
                <?php endif; ?>
        </div>
              <h3 class="vision-white-card-title"><?= esc($item['title'] ?? '') ?></h3>
              <p class="vision-white-card-text"><?= esc($item['text'] ?? '') ?></p>
            </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>
  </section>

  <!-- Piliers - New format with images and overlay icons -->
  <section id="piliers" class="py-5" data-aos="fade-up" data-aos-delay="200">
    <div class="container">
      <span class="section-eyebrow"><?= esc($content['pillars']['eyebrow'] ?? 'Mon Programme') ?></span>
      <h2 class="section-title text-brand mb-2">Les 10 axes de mon programme</h2>
      <p class="section-subtitle mb-5"><?= esc($content['pillars']['subtitle'] ?? '') ?></p>
      <div class="row g-4">
        <?php 
        $pillarImages = ['hero.jpg', 'portrait.png', 'manifesto-preview.jpg'];
        foreach (($content['pillars']['items'] ?? []) as $index => $item): 
          $imageIndex = $index % count($pillarImages);
          $pillarImage = $pillarImages[$imageIndex];
        ?>
          <div class="col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 ?>" data-aos-duration="800">
            <div class="pillar-card-new">
              <div class="pillar-card-image-wrapper" style="background-image: url('/assets/<?= esc($pillarImage) ?>');">
                <div class="pillar-card-icon-center">
                  <?php 
                  // Utiliser l'image asset si disponible, sinon l'icône Bootstrap
                  $iconImage = $item['icon_image'] ?? '';
                  if (!empty($iconImage)): 
                  ?>
                    <img src="/assets/<?= esc($iconImage) ?>" alt="<?= esc($item['title'] ?? '') ?>" class="pillar-icon-image" />
                  <?php else: ?>
                    <i class="<?= esc($item['icon'] ?? 'bi bi-check-circle') ?>"></i>
                  <?php endif; ?>
                </div>
                <div class="pillar-card-number-overlay">
                  <?= $index + 1 ?>
                </div>
              </div>
              <div class="pillar-card-body">
                <h3 class="pillar-card-title"><?= esc($item['title'] ?? '') ?></h3>
                <p class="pillar-card-text"><?= esc($item['text'] ?? '') ?></p>
                <a href="#piliers" class="pillar-card-link">
                  <i class="bi bi-arrow-right"></i> En savoir plus
                </a>
              </div>
            </div>
          </div>
        <?php endforeach; ?>
          </div>
        </div>
  </section>

  <!-- Manifeste (ancre vers PDF et aperçu) -->
  <!-- Grandes activités prévues - Strength Of Candidate model -->
  <section id="activites" class="py-5" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <div class="strength-section-header text-center mb-5">
        <span class="section-eyebrow strength-eyebrow">
          <?= esc($content['activities']['eyebrow'] ?? 'Programme d\'action') ?> ★★★
        </span>
        <h2 class="section-title text-brand mb-3"><?= esc($content['activities']['title'] ?? 'Grandes activités prévues') ?></h2>
        <?php if (!empty($content['activities']['subtitle'])): ?>
          <p class="strength-mission"><?= raw_text($content['activities']['subtitle']) ?></p>
        <?php endif; ?>
      </div>

      <?php 
      $allBlocks = $content['activities']['blocks'] ?? [];
      $totalBlocks = count($allBlocks);
      $blocksPerRow = 6; // 3 left + 3 right per row
      $rows = ceil($totalBlocks / $blocksPerRow);
      
      for ($row = 0; $row < $rows; $row++):
        $startIndex = $row * $blocksPerRow;
        $rowBlocks = array_slice($allBlocks, $startIndex, $blocksPerRow);
        $leftColumnBlocks = [];
        $rightColumnBlocks = [];
        
        // Distribute blocks: odd indices to left, even indices to right
        foreach ($rowBlocks as $index => $block) {
          $globalIndex = $startIndex + $index;
          if ($globalIndex % 2 === 0) {
            $leftColumnBlocks[] = ['block' => $block, 'number' => $globalIndex + 1];
          } else {
            $rightColumnBlocks[] = ['block' => $block, 'number' => $globalIndex + 1];
          }
        }
      ?>
        <div class="strength-content-wrapper<?= $row > 0 ? ' strength-row-margin' : '' ?>">
          <!-- Left column: activity boxes -->
          <div class="strength-column strength-column-left">
            <?php foreach ($leftColumnBlocks as $idx => $item): 
              $block = $item['block'];
              $boxNumber = $item['number'];
              $firstItem = !empty($block['items']) ? $block['items'][0] : '';
            ?>
              <div class="strength-box" data-aos="fade-right" data-aos-delay="<?= ($idx * 100) + 150 ?>">
                <div class="strength-box-header">
                  <strong class="strength-box-title"><?= esc(preg_replace('/^[A-Z]\.\s*/', '', $block['title'] ?? '')) ?></strong>
                  <span class="strength-box-number"><?= sprintf('%02d', $boxNumber) ?></span>
                  <span class="strength-box-stars">★★★</span>
                </div>
                <p class="strength-box-text"><?= raw_text($firstItem) ?></p>
              </div>
            <?php endforeach; ?>
          </div>

          <!-- Center: Portrait image with red cross background (only on first row) -->
          <?php if ($row === 0): ?>
            <div class="strength-image-center">
              <div class="strength-image-wrapper">
                <img src="/assets/portrait.png" alt="<?= esc($content['portrait']['image_alt'] ?? 'Portrait du candidat') ?>" class="strength-portrait" loading="lazy" />
                <div class="strength-red-cross"></div>
              </div>
            </div>
          <?php else: ?>
            <!-- Empty spacer for alignment on subsequent rows -->
            <div class="strength-image-center strength-image-spacer"></div>
          <?php endif; ?>

          <!-- Right column: activity boxes -->
          <div class="strength-column strength-column-right">
            <?php foreach ($rightColumnBlocks as $idx => $item): 
              $block = $item['block'];
              $boxNumber = $item['number'];
              $firstItem = !empty($block['items']) ? $block['items'][0] : '';
            ?>
              <div class="strength-box" data-aos="fade-left" data-aos-delay="<?= ($idx * 100) + 150 ?>">
                <div class="strength-box-header">
                  <strong class="strength-box-title"><?= esc(preg_replace('/^[A-Z]\.\s*/', '', $block['title'] ?? '')) ?></strong>
                  <span class="strength-box-number"><?= sprintf('%02d', $boxNumber) ?></span>
                  <span class="strength-box-stars">★★★</span>
                </div>
                <p class="strength-box-text"><?= raw_text($firstItem) ?></p>
              </div>
            <?php endforeach; ?>
          </div>
        </div>
      <?php endfor; ?>
    </div>
  </section>

  <section id="manifeste" class="py-5 bg-cream" data-aos="fade-up" data-aos-delay="200">
    <div class="container">
      <div class="row g-4 align-items-center">
        <div class="col-lg-6">
          <span class="section-eyebrow"><?= esc($content['manifeste']['eyebrow'] ?? '') ?></span>
          <h2 class="section-title text-brand mb-3"><?= esc($content['manifeste']['title'] ?? '') ?></h2>
          <p class="section-subtitle mb-3"><?= esc($content['manifeste']['description'] ?? '') ?></p>
          <div class="d-flex flex-wrap gap-2">
            <?php foreach (($content['manifeste']['ctas'] ?? []) as $cta): ?>
              <a class="<?= esc(($cta['style'] ?? '') === 'primary' ? 'btn btn-brand' : 'btn btn-outline-gold') ?>" href="<?= esc($cta['href'] ?? '#') ?>"<?= build_attributes($cta['attributes'] ?? []) ?>>
                <?php if (!empty($cta['icon'])): ?><i class="<?= esc($cta['icon']) ?> me-2"></i><?php endif; ?><?= esc($cta['label'] ?? '') ?>
              </a>
            <?php endforeach; ?>
          </div>
        </div>
        <div class="col-lg-6">
          <div class="card overflow-hidden">
            <img src="/assets/manifesto-preview.jpg" class="img-fluid" alt="<?= esc($content['manifeste']['image_alt'] ?? '') ?>" />
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Agenda / Timeline - DÉSACTIVÉ (Mobilisation nationale) -->
  <?php if (false): // Section désactivée par demande ?>
  <section id="agenda" class="py-5" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <span class="section-eyebrow"><?= esc($content['agenda']['eyebrow'] ?? '') ?></span>
      <h2 class="section-title text-brand mb-4"><?= esc($content['agenda']['title'] ?? '') ?></h2>
      <div class="row">
        <div class="col-lg-7">
          <div class="timeline">
            <?php foreach (($content['agenda']['timeline'] ?? []) as $item): ?>
            <div class="timeline-item">
                <h3 class="h6 mb-1"><?= esc($item['title'] ?? '') ?></h3>
                <p class="mb-0"><?= esc($item['text'] ?? '') ?></p>
            </div>
            <?php endforeach; ?>
          </div>
        </div>
        <div class="col-lg-5">
          <div class="card p-4 h-100 card-highlight">
            <h3 class="h6"><?= esc($content['agenda']['form']['heading'] ?? '') ?></h3>
            <form id="agendaForm" novalidate>
              <?php foreach (($content['agenda']['form']['fields'] ?? []) as $field): ?>
                <?php $fieldId = $field['id'] ?? $field['name'] ?? ''; ?>
              <div class="mb-3">
                  <label for="<?= esc($fieldId) ?>" class="form-label"><?= esc($field['label'] ?? '') ?></label>
                  <?php if (($field['type'] ?? '') === 'textarea'): ?>
                    <textarea class="form-control" id="<?= esc($fieldId) ?>" name="<?= esc($field['name'] ?? '') ?>" placeholder="<?= esc($field['placeholder'] ?? '') ?>"<?= !empty($field['rows']) ? ' rows="' . esc($field['rows']) . '"' : '' ?><?= !empty($field['required']) ? ' required' : '' ?>></textarea>
                  <?php else: ?>
                    <input type="<?= esc($field['type'] ?? 'text') ?>" class="form-control" id="<?= esc($fieldId) ?>" name="<?= esc($field['name'] ?? '') ?>" placeholder="<?= esc($field['placeholder'] ?? '') ?>"<?= !empty($field['required']) ? ' required' : '' ?> />
                  <?php endif; ?>
                  <?php if (!empty($field['invalid_feedback'])): ?><div class="invalid-feedback"><?= esc($field['invalid_feedback']) ?></div><?php endif; ?>
              </div>
              <?php endforeach; ?>
              <button class="btn btn-brand w-100" type="submit"><i class="bi bi-send me-2"></i><?= esc($content['agenda']['form']['submit_label'] ?? '') ?></button>
              <p class="small text-muted mt-2 mb-0"><?= esc($content['agenda']['form']['disclaimer'] ?? '') ?></p>
            </form>
          </div>
        </div>
      </div>
    </div>
  </section>
  <?php endif; ?>

  <!-- Médias -->
  <section id="medias" class="py-5 bg-cream" data-aos="fade-up" data-aos-delay="200">
    <div class="container">
      <span class="section-eyebrow"><?= esc($content['media']['eyebrow'] ?? '') ?></span>
      <h2 class="section-title text-brand mb-2"><?= esc($content['media']['title'] ?? '') ?></h2>
      <p class="section-subtitle mb-4"><?= esc($content['media']['subtitle'] ?? '') ?></p>
      <div class="row g-4">
        <?php foreach (($content['media']['items'] ?? []) as $item): ?>
        <div class="col-md-6 col-lg-4">
          <div class="card h-100 media-card">
              <img src="<?= esc($item['image'] ?? '') ?>" class="card-img-top" alt="<?= esc($item['alt'] ?? '') ?>" loading="lazy" />
            <div class="card-body">
                <h3><?= esc($item['title'] ?? '') ?></h3>
                <p><?= esc($item['text'] ?? '') ?></p>
                <a class="btn btn-outline-gold btn-sm" href="<?= esc($item['href'] ?? '#') ?>" aria-label="<?= esc($item['link_label'] ?? '') ?>">
                  <?= esc($item['link_label'] ?? '') ?>
                  <i class="bi bi-arrow-right ms-2"></i>
                </a>
        </div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <!-- Endorsements / Témoignages -->
  <section id="temoignages" class="py-5" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <span class="section-eyebrow"><?= esc($content['testimonials']['eyebrow'] ?? '') ?></span>
      <h2 class="section-title text-brand mb-4"><?= esc($content['testimonials']['title'] ?? '') ?></h2>
      <div class="row g-4">
        <?php foreach (($content['testimonials']['items'] ?? []) as $item): ?>
        <div class="col-md-6 col-lg-4">
          <div class="card h-100 testimonial-card">
              <blockquote><?= raw_text($item['quote'] ?? '') ?></blockquote>
              <div class="author">— <?= esc($item['author'] ?? '') ?></div>
        </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <!-- FAQ -->
  <section id="faq" class="py-5 bg-cream" data-aos="fade-up" data-aos-delay="200">
    <div class="container">
      <span class="section-eyebrow"><?= esc($content['faq']['eyebrow'] ?? '') ?></span>
      <h2 class="section-title text-brand mb-4"><?= esc($content['faq']['title'] ?? '') ?></h2>
      <div class="accordion" id="faqAcc">
        <?php foreach (($content['faq']['items'] ?? []) as $index => $item): ?>
          <?php $collapseId = 'faq_item_' . $index; $headingId = 'faq_heading_' . $index; $isFirst = $index === 0; ?>
        <div class="accordion-item">
            <h2 class="accordion-header" id="<?= esc($headingId) ?>">
              <button class="accordion-button<?= $isFirst ? '' : ' collapsed' ?>" type="button" data-bs-toggle="collapse" data-bs-target="#<?= esc($collapseId) ?>" aria-expanded="<?= $isFirst ? 'true' : 'false' ?>" aria-controls="<?= esc($collapseId) ?>">
                <?= esc($item['question'] ?? '') ?>
              </button>
            </h2>
            <div id="<?= esc($collapseId) ?>" class="accordion-collapse collapse<?= $isFirst ? ' show' : '' ?>" data-bs-parent="#faqAcc">
              <div class="accordion-body"><?= esc($item['answer'] ?? '') ?></div>
        </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>
  </section>

  <!-- Contact / Soutien -->
  <section id="contact" class="py-5" data-aos="fade-up" data-aos-delay="100">
    <div class="container">
      <div class="row g-4">
        <div class="col-lg-6">
          <span class="section-eyebrow"><?= esc($content['contact']['eyebrow'] ?? '') ?></span>
          <h2 class="section-title text-brand mb-3"><?= esc($content['contact']['title'] ?? '') ?></h2>
          <p class="section-subtitle mb-4"><?= esc($content['contact']['subtitle'] ?? '') ?></p>
          <form id="supportForm" novalidate>
            <div class="row g-3">
              <?php foreach (($content['contact']['form']['fields'] ?? []) as $field): ?>
                <?php $wrapperClass = $field['wrapper_class'] ?? 'col-12'; $fieldId = $field['id'] ?? $field['name'] ?? ''; ?>
                <div class="<?= esc($wrapperClass) ?>">
                  <label for="<?= esc($fieldId) ?>" class="form-label"><?= esc($field['label'] ?? '') ?></label>
                  <?php if (($field['type'] ?? '') === 'select'): ?>
                    <select id="<?= esc($fieldId) ?>" name="<?= esc($field['name'] ?? '') ?>" class="form-select"<?= !empty($field['required']) ? ' required' : '' ?>>
                      <option value="" selected disabled><?= esc($field['placeholder'] ?? '') ?></option>
                      <?php foreach (($field['options'] ?? []) as $option): ?>
                        <option value="<?= esc($option) ?>"><?= esc($option) ?></option>
                      <?php endforeach; ?>
                </select>
                  <?php elseif (($field['type'] ?? '') === 'textarea'): ?>
                    <textarea id="<?= esc($fieldId) ?>" name="<?= esc($field['name'] ?? '') ?>" rows="<?= esc($field['rows'] ?? 3) ?>" class="form-control" placeholder="<?= esc($field['placeholder'] ?? '') ?>"<?= !empty($field['required']) ? ' required' : '' ?>></textarea>
                  <?php else: ?>
                    <input type="<?= esc($field['type'] ?? 'text') ?>" id="<?= esc($fieldId) ?>" name="<?= esc($field['name'] ?? '') ?>" class="form-control" placeholder="<?= esc($field['placeholder'] ?? '') ?>"<?= !empty($field['required']) ? ' required' : '' ?> />
                  <?php endif; ?>
                  <?php if (!empty($field['invalid_feedback'])): ?><div class="invalid-feedback"><?= esc($field['invalid_feedback']) ?></div><?php endif; ?>
              </div>
              <?php endforeach; ?>
              <div class="col-12 d-grid">
                <button class="btn btn-brand" type="submit"><i class="bi bi-send me-2"></i><?= esc($content['contact']['form']['submit_label'] ?? '') ?></button>
              </div>
              <p class="small text-muted mb-0"><?= esc($content['contact']['form']['disclaimer'] ?? '') ?></p>
            </div>
          </form>
        </div>
        <div class="col-lg-6">
          <div class="card p-4 h-100 contact-card">
            <h3 class="h5 mb-4" style="font-family: 'Barlow', sans-serif; color: var(--brand-primary);"><?= esc($content['contact']['contacts_card']['title'] ?? '') ?></h3>
            <ul class="list-unstyled mb-4">
              <?php foreach (($content['contact']['contacts_card']['items'] ?? []) as $item): ?>
                <li>
                  <i class="<?= esc($item['icon'] ?? 'bi bi-circle') ?> me-2 text-brand" style="font-size: 1.1rem;"></i>
                  <?php if (!empty($item['href'])): ?>
                    <a href="<?= esc($item['href']) ?>"<?= build_attributes($item['attributes'] ?? []) ?>><?= esc($item['text'] ?? '') ?></a>
                  <?php else: ?>
                    <?= esc($item['text'] ?? '') ?>
                  <?php endif; ?>
                </li>
              <?php endforeach; ?>
            </ul>
            <h3 class="h6 mb-3" style="font-family: 'Barlow', sans-serif; color: var(--brand-primary);"><?= esc($content['contact']['contacts_card']['social_title'] ?? '') ?></h3>
            <div class="d-flex gap-2">
              <?php foreach (($content['contact']['contacts_card']['social_links'] ?? []) as $link): ?>
                <a class="btn btn-outline-gold" href="<?= esc($link['href'] ?? '#') ?>" aria-label="<?= esc($link['aria_label'] ?? '') ?>" style="width: 44px; height: 44px; padding: 0; display: flex; align-items: center; justify-content: center;">
                  <i class="<?= esc($link['icon'] ?? '') ?>"></i>
                </a>
              <?php endforeach; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <!-- Pied de page -->
  <footer class="bg-brand text-white py-4">
    <div class="container d-flex flex-column flex-lg-row align-items-center justify-content-between gap-3">
      <?php
        $footerText = esc($content['footer']['copyright'] ?? '');
        $footerText = str_replace('%YEAR%', '<span id="year"></span>', $footerText);
      ?>
      <div class="small"><?= raw_text($footerText) ?></div>
      <div class="small">Slogan : <em><?= esc($content['footer']['slogan'] ?? '') ?></em></div>
    </div>
  </footer>

  <!-- JS Bootstrap -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  
  <!-- AOS - Animate On Scroll -->
  <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
  
  <!-- JS fonctionnel minimal -->
  <?php
    $mailToLink = $content['contact']['contacts_card']['items'][0]['href'] ?? 'mailto:contact@campagne-aboubakar.bi';
  ?>
  <script>
    // Année dynamique
    document.getElementById('year').textContent = new Date().getFullYear();

    // Partage WhatsApp – réécrit l'URL avec l'URL courante
    const shareBtn = document.getElementById('btnShareWhatsApp');
    const shareMessagePrefix = <?= json_encode($content['hero']['share_message_prefix'] ?? '') ?>;
    if (shareBtn) {
      shareBtn.addEventListener('click', () => {
        const url = encodeURIComponent(window.location.href);
        const text = encodeURIComponent(shareMessagePrefix);
        shareBtn.href = `https://wa.me/?text=${text}${url}`;
      });
    }

    // Validation Bootstrap forms
    function enableValidation(formId) {
      const form = document.getElementById(formId);
      if (!form) return;
      form.addEventListener('submit', function (event) {
        if (!form.checkValidity()) {
          event.preventDefault();
          event.stopPropagation();
        } else {
          // Fallback mailto : adapter vers votre backend si dispo
          event.preventDefault();
          const data = new FormData(form);
          const subject = encodeURIComponent(<?= json_encode($content['forms']['mail_subject'] ?? '') ?>);
          const body = [...data.entries()].map(([k, v]) => `${k}: ${v}`).join('\n');
          const mailLink = <?= json_encode($mailToLink) ?>.split('?')[0];
          window.location.href = `${mailLink}?subject=${subject}&body=${encodeURIComponent(body)}`;
        }
        form.classList.add('was-validated');
      }, false);
    }

    // Activation de la validation côté client
    enableValidation('supportForm');
    enableValidation('agendaForm');

    // Initialiser AOS (Animate On Scroll)
    if (typeof AOS !== 'undefined') {
      AOS.init({
        duration: 800,
        easing: 'ease-out-cubic',
        once: true,
        offset: 100,
        delay: 0,
        disable: window.innerWidth < 768 ? 'mobile' : false
      });
    }

    // Gérer les boutons "Voir plus" / "Voir moins"
    document.addEventListener('DOMContentLoaded', function() {
      const portraitMoreBtn = document.querySelector('[data-bs-target="#portraitMoreSections"]');
      const visionMoreBtn = document.querySelector('[data-bs-target="#visionMoreItems"]');
      
       if (portraitMoreBtn) {
         const portraitTarget = document.querySelector('#portraitMoreSections');
         portraitTarget.addEventListener('shown.bs.collapse', function() {
           portraitMoreBtn.innerHTML = '<i class="bi bi-chevron-up me-2"></i>Voir moins';
           if (typeof AOS !== 'undefined') {
             AOS.refresh();
           }
         });
         portraitTarget.addEventListener('hidden.bs.collapse', function() {
           portraitMoreBtn.innerHTML = '<i class="bi bi-chevron-down me-2"></i>Voir plus';
         });
       }

       if (visionMoreBtn) {
         const visionTarget = document.querySelector('#visionMoreItems');
         visionTarget.addEventListener('shown.bs.collapse', function() {
           visionMoreBtn.innerHTML = '<i class="bi bi-chevron-up me-2"></i>Voir moins';
           if (typeof AOS !== 'undefined') {
             AOS.refresh();
           }
         });
         visionTarget.addEventListener('hidden.bs.collapse', function() {
           visionMoreBtn.innerHTML = '<i class="bi bi-chevron-down me-2"></i>Voir tous les objectifs';
         });
       }
    });
  </script>

  <!-- Astuces déploiement:
    1) Remplacer les images /assets/* (portrait.jpg, hero.jpg, manifesto-preview.jpg, media*.jpg).
    2) Mettre à jour /docs/manifeste-aboubakar.pdf.
    3) Configurer le domaine et l'URL og:url.
    4) Remplacer les liens WhatsApp, réseaux et email.
    5) (Option) Brancher un backend minimal (Node/Express, PHP, etc.) pour stocker les formulaires.
  -->
</body>
</html>

